/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.databind.impl.adapter;

import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.Token;
import io.gitlab.jfronny.commons.serialize.databind.ObjectMapper;
import io.gitlab.jfronny.commons.serialize.databind.TypeAdapterFactory;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeAdapter;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeToken;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeUtils;
import io.gitlab.jfronny.commons.serialize.databind.impl.MapKeyReader;
import io.gitlab.jfronny.commons.serialize.databind.impl.MapKeyWriter;
import io.gitlab.jfronny.commons.serialize.databind.impl.adapter.TypeAdapterRuntimeTypeWrapper;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import io.gitlab.jfronny.commons.tuple.Tuple;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapTypeAdapterFactory
implements TypeAdapterFactory {
    @Override
    public <T> TypeAdapter<T> create(ObjectMapper mapper, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class<T> rawType = typeToken.getRawType();
        if (!Map.class.isAssignableFrom(rawType)) {
            return null;
        }
        Type[] keyAndValueTypes = TypeUtils.getMapKeyAndValueTypes(type, rawType);
        TypeAdapter<?> keyAdapter = mapper.getAdapter(TypeToken.get(keyAndValueTypes[0]));
        TypeAdapter<?> valueAdapter = mapper.getAdapter(TypeToken.get(keyAndValueTypes[1]));
        MapTypeAdapter result = new MapTypeAdapter(mapper, keyAndValueTypes[0], keyAdapter, keyAndValueTypes[1], valueAdapter, typeToken);
        return result;
    }

    private static class MapTypeAdapter<K, V>
    extends TypeAdapter<Map<K, V>> {
        private final TypeAdapter<K> keyTypeAdapter;
        private final TypeAdapter<V> valueTypeAdapter;
        private final ThrowingSupplier<?, MalformedDataException> implClassConstructor;

        public MapTypeAdapter(ObjectMapper context, Type keyType, TypeAdapter<K> keyTypeAdapter, Type valueType, TypeAdapter<V> valueTypeAdapter, TypeToken<?> implClass) {
            this.keyTypeAdapter = new TypeAdapterRuntimeTypeWrapper<K>(context, keyTypeAdapter, keyType).viewWrapped();
            this.valueTypeAdapter = new TypeAdapterRuntimeTypeWrapper<V>(context, valueTypeAdapter, valueType).viewWrapped();
            this.implClassConstructor = TypeUtils.constructor(implClass);
        }

        @Override
        public <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(Map<K, V> value, Writer writer) throws TEx, MalformedDataException {
            writer.beginObject();
            LinkedHashMap tmp = new LinkedHashMap();
            ArrayList<Map.Entry<K, V>> toWrite = new ArrayList<Map.Entry<K, V>>(value.entrySet());
            int written = 0;
            for (Map.Entry entry : toWrite) {
                MapKeyWriter keyWriter = new MapKeyWriter();
                try {
                    try {
                        this.keyTypeAdapter.serialize(entry.getKey(), keyWriter);
                    }
                    catch (MalformedDataException e) {
                        if (!keyWriter.isFailureOrigin()) {
                            throw new MalformedDataException("Could not serialize key", e);
                        }
                        writer.beginArray();
                        for (Map.Entry se : tmp.entrySet()) {
                            for (String comment : (List)((Tuple)se.getValue()).right()) {
                                writer.comment(comment);
                            }
                            writer.name((String)se.getKey());
                            this.valueTypeAdapter.serialize(((Tuple)se.getValue()).left(), writer);
                        }
                        for (Map.Entry se : toWrite) {
                            if (written-- > 0) continue;
                            writer.beginArray();
                            this.keyTypeAdapter.serialize(se.getKey(), writer);
                            this.valueTypeAdapter.serialize(se.getValue(), writer);
                            writer.endArray();
                        }
                        writer.endArray();
                        keyWriter.close();
                        return;
                    }
                    tmp.put(keyWriter.getResult(), Tuple.of(entry.getValue(), keyWriter.getComments()));
                    ++written;
                }
                finally {
                    try {
                        keyWriter.close();
                    }
                    catch (Throwable throwable) {
                        Throwable e;
                        e.addSuppressed(throwable);
                    }
                }
            }
            for (Map.Entry entry : tmp.entrySet()) {
                for (String comment : (List)((Tuple)entry.getValue()).right()) {
                    writer.comment(comment);
                }
                writer.name((String)entry.getKey());
                this.valueTypeAdapter.serialize(((Tuple)entry.getValue()).left(), writer);
            }
            writer.endObject();
        }

        @Override
        public <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> Map<K, V> deserialize(Reader reader) throws TEx, MalformedDataException {
            Token peek = reader.peek();
            Map map = (Map)this.implClassConstructor.get();
            if (peek == Token.BEGIN_ARRAY) {
                reader.beginArray();
                while (reader.hasNext()) {
                    reader.beginArray();
                    K key = this.keyTypeAdapter.deserialize(reader);
                    V value = this.valueTypeAdapter.deserialize(reader);
                    if (map.put(key, value) != null && !reader.isLenient()) {
                        throw new MalformedDataException("duplicate key: " + String.valueOf(key));
                    }
                    reader.endArray();
                }
                reader.endArray();
                return map;
            }
            if (peek == Token.BEGIN_OBJECT) {
                reader.beginObject();
                while (reader.hasNext()) {
                    K key;
                    try (MapKeyReader keyReader = new MapKeyReader(reader.getPath(), reader.getPreviousPath(), reader.nextName());){
                        key = this.keyTypeAdapter.deserialize(keyReader);
                    }
                    V value = this.valueTypeAdapter.deserialize(reader);
                    if (map.put(key, value) == null || reader.isLenient()) continue;
                    throw new MalformedDataException("duplicate key: " + String.valueOf(key));
                }
                reader.endObject();
                return map;
            }
            throw new MalformedDataException("Expected object or array but was " + String.valueOf((Object)peek));
        }
    }
}

